import java.util.Scanner;

public class Listing12_6
{
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Deklarujemy zmienną, w której zapiszemy numer telefonu
      String phoneNumber;
      
      // Prosimy użytkownika o wprowadzenie numeru telefonu
      System.out.println("Wprowadź numer telefonu. Numer powinien mieć");
      System.out.println("następujący format: (XXX)XXX-XXXX.");
      phoneNumber = keyboard.nextLine();
    
      // Jeśli wprowadzone dane mają prawidłowy format, usuwany z numeru telefonu formatowanie
      if (isValidFormat(phoneNumber))
      {
        System.out.println("Niesformatowany numer telefonu: " + unformat(phoneNumber));
      }
      else
      {
         System.out.println("Numer telefonu ma niewłaściwy format.");
      }
   }
   
   // Metoda isValidFormat przyjmuje jako argument łańcuch znakowy
   // i sprawdza, czy jest on odpowiednio sformatowanym numerem telefonu
   // w Stanach Zjednoczonych
   // Numer powinien mieć format (XXX)XXX-XXXX
   // Jeśli numer telefonu ma prawidłowy format, metoda zwraca wartość True
   // W przeciwnym razie zwraca wartość False
   public static Boolean isValidFormat(String str)
   {
      // Zmienna lokalna wskazująca, czy numer jest prawidłowo sformatowany
      Boolean valid;
   
      // Sprawdzamy, czy łańcuch znakowy str jest prawidłowo sformatowany
      if (str.length() == 13 && str.charAt(0) == '(' &&
          str.charAt(4) == ')' && str.charAt(8) == '-')
		{
         valid = true;
		}
      else
		{
         valid = false;
      }
      
      // Zwracamy wartość zapisaną w zmiennej valid
      return valid;
   }

   // Metoda unformat przyjmuje jako argument łańcuch znakowy
   // Zakładamy, że łańcuch znakowy to prawidłowo sformatowany numer telefonu
   // w postaci (XXX)XXX-XXXX.
   // Metoda usuwa z łańcucha znakowego formatowanie
   // (nawiasy i łącznik)
   public static String unformat(String str)
   {
      // Zapisujemy łańcuch znakowy str w obiekcie StringBuilder
      StringBuilder strb = new StringBuilder(str);
		
      // Na początku usuwamy lewy nawias na pozycji 0
      strb.delete(0, 1);
		
      // Następnie usuwamy prawy nawias; po usunięciu lewego nawiasu
      // prawy nawias będzie się znajdował
      // na pozycji 3
      strb.delete(3, 4);
      
      // Następnie usuwamy łącznik; po usunięciu obu nawiasów
      // łącznik będzie się znajdował
      // na pozycji 6
      strb.delete(6, 7);
		
      // Zwracamy łańcych znakowy zapisany  
      // w obiekcie StringBuilder
      return strb.toString();
   }
}
